/**
 * @file clock_xmc1.h
 * @date 2015-07-08
 *
 * NOTE:
 * This file is generated by DAVE. Any manual modification done to this file will be lost when the code is regenerated.
 *
 * @cond
 ***********************************************************************************************************************
 * CLOCK_XMC1 v4.0.18 - APP to configure System and Peripheral Clocks.
 *
 * Copyright (c) 2015-2016, Infineon Technologies AG
 * All rights reserved.                        
 *                                             
 * Redistribution and use in source and binary forms, with or without modification,are permitted provided that the           
 * following conditions are met:   
 *                                                                              
 *   Redistributions of source code must retain the above copyright notice, this list of conditions and the  following   
 *   disclaimer.                        
 * 
 *   Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following   
 *   disclaimer in the documentation and/or other materials provided with the distribution.     
 *                         
 *   Neither the name of the copyright holders nor the names of its contributors may be used to endorse or promote 
 *   products derived from this software without specific prior written permission. 
 *                                             
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,  
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE   
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE  FOR ANY DIRECT, INDIRECT, INCIDENTAL,  
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR        
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,      
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT  OF THE   
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.    
 *                                                                              
 * To improve the quality of the software, users are encouraged to share modifications, enhancements or bug fixes       
 * with Infineon Technologies AG (dave@infineon.com).         
 ***********************************************************************************************************************
 *
 * Change History
 * --------------
 *
 * 2015-02-16:
 *     - Initial version for DAVEv4 <BR>
 * 2015-05-08:
 *     - Version check added for required LLDs <BR>
 * 2015-06-20:
 *     - Version check added for XMCLib dependency <BR>
 * 2015-09-22:
 *     - CLOCK_XMC1_STATUS enum and CLOCK_XMC1 data structure are provided. <BR>
 *     - CLOCK_XMC4_Init and CLOCK_XMC4_StepSystemPllFrequency() APIs are provided. <BR>
 * 2015-10-19:
 *     - non-weak OSCHP_GetFrequency function is provided. <BR>
 *     - CLOCK_XMC1_IsDCO1ExtRefCalibrationReady function is provided. <BR>
 * 2016-05-24:
 *     - API snippets are improved. <BR>
 * 2016-07-08:
 *     - Fixed incorrect case for an included header.<br>
 *
 * @endcond 
 *
 */

#ifndef CLOCK_XMC1_H
#define CLOCK_XMC1_H

/***********************************************************************************************************************
 * HEADER FILES                                                                                                      
 **********************************************************************************************************************/
#include <xmc_scu.h>
#include <DAVE_Common.h>
#include "clock_xmc1_conf.h"
#ifdef CLOCK_XMC1_INTERRUPT_ENABLED
#include "../GLOBAL_SCU_XMC1/global_scu_xmc1.h"
#endif
 /**********************************************************************************************************************
 * MACROS
 **********************************************************************************************************************/
#if (!((XMC_LIB_MAJOR_VERSION == 2U) && \
       (XMC_LIB_MINOR_VERSION >= 0U) && \
       (XMC_LIB_PATCH_VERSION >= 0U)))
#error "CLOCK_XMC1 requires XMC Peripheral Library v2.0.0 or higher"
#endif

/**
 * @ingroup CLOCK_XMC1_publicparam
 * @{
 */
/**
 *  @brief Initialization data structure for CLOCK_XMC1 APP
 */

/**
 * @}
 */

 /**********************************************************************************************************************
 * ENUMS
 **********************************************************************************************************************/
/**
 * @ingroup CLOCK_XMC1_enumerations
 * @{
 */
/*
 * @brief enumeration for CLOCK_XMC1 APP
 */
typedef enum CLOCK_XMC1_STATUS
{
  CLOCK_XMC1_STATUS_SUCCESS = 0U,        /**<APP initialization is success */
  CLOCK_XMC1_STATUS_FAILURE = 1U         /**<APP initialization is failure */
} CLOCK_XMC1_STATUS_t;

/**
 * @}
 */

/**********************************************************************************************************************
* DATA STRUCTURES
**********************************************************************************************************************/
/**
 * @ingroup CLOCK_XMC1_datastructures
 * @{
 */

/**
 * @brief Configuration structure for CLOCK_XMC1 APP
 */
typedef struct CLOCK_XMC1
{
#ifdef CLOCK_XMC1_INTERRUPT_ENABLED

  GLOBAL_SCU_XMC1_t *const global_scu_handleptr;  /**<pointer to GLOBAL_SCU_XMC1 APP handler */
#ifdef CLOCK_XMC1_LOCI_EVENT_ENABLED
  void (*callback_function_loci)(void);  /**<function pointer to user callback */
#endif
#ifdef CLOCK_XMC1_STDBYCLKFAIL_EVENT_ENABLED
  void (*callback_function_stdbyclkfail)(void);  /**<function pointer to user callback */
#endif

#if (UC_SERIES == XMC14)

#ifdef CLOCK_XMC1_LOSS_EXT_CLOCK_EVENT_ENABLED
  void (*callback_function_loss_ext_clock)(void);  /**<function pointer to user callback */
#endif
#ifdef CLOCK_XMC1_DCO1_OUT_SYNC_EVENT_ENABLED
  void (*callback_function_dco1_out_sync)(void);  /**<function pointer to user callback */
#endif
#endif

#endif
  bool init_status;  /**<APP is initialized or not. */
} CLOCK_XMC1_t;

/**
 * @}
 */

#ifdef __cplusplus
extern "C" {
#endif
/***********************************************************************************************************************
 * API Prototypes
 **********************************************************************************************************************/
/**
 * @ingroup CLOCK_XMC1_apidoc
 * @{
 */
/**
 * @brief Get CLOCK_XMC1 APP version
 * @return DAVE_APP_VERSION_t APP version information (major, minor and patch number)
 *
 * \par<b>Description: </b><br>
 * The function can be used to check application software compatibility with a
 * specific version of the APP.
 *
 * Example Usage:
 *
 * @code
 * #include <DAVE.h>
 *
 * int main(void)
 * {
 *   DAVE_STATUS_t init_status;
 *   DAVE_APP_VERSION_t version;
 *
 *   // Initialize CLOCK_XMC1 APP:
 *   // SystemCoreClockSetup() is called from SystemInit().
 *   init_status = DAVE_Init();
 *  if(DAVE_STATUS_SUCCESS == init_status)
 *  {
 *    version = CLOCK_XMC1_GetAppVersion();
 *    if (version.major != 4U) {
 *      // Probably, not the right version.
 *    }
 *
 *    // More code here
 *    while(1) {
 *    }
 *  }
 *  return (1);
 * }
 * @endcode<BR>
 */
DAVE_APP_VERSION_t CLOCK_XMC1_GetAppVersion(void);

/**
 * @brief Initializes a CLOCK_XMC1 APP instance
 * @param handle address of CLOCK_XMC1 APP handler
 * @return
 *            CLOCK_XMC1_STATUS_SUCCESS             : if initialization is successful\n
 *            CLOCK_XMC1_STATUS_FAILURE             : if initialization is failed
 *
 * \par<b>Description:</b><br>
 * CLOCK_XMC1_Init API is called during initialization of DAVE APPS. This API Initializes GLOBAL_SCU_XMC1 APP
 * for setting the interrupts and user callback registration.
 *
 * \par<b>Example Usage:</b><br>
 *
 * @code
 * #include <DAVE.h>
 *
 * int main(void)
 * {
 *   DAVE_STATUS_t status;
 *
 *   status = DAVE_Init();  //  CLOCK_XMC1_Init API is called during initialization of DAVE APPS
 *   if(DAVE_STATUS_SUCCESS == status)
 *   {
 *    // user code
 *
 *     while(1)
 *     {
 *
 *     }
 *   }
 *   return (1);
 * }
 *
 * @endcode<BR>
 */
CLOCK_XMC1_STATUS_t CLOCK_XMC1_Init(CLOCK_XMC1_t *handle);

/**
 * @brief API for ramping up/down the system clock frequency
 * @param target_freq required frequency in Hz. \n
 * \b Range:  (DCO1/256) to DC01 when Clock Control Unit (CCU) source is DC01,\n
 *            (OSC_HP/256) to OSC_HP when CCU source is OSC_HP (External Crystal/Direct input mode) for XMC14 device.\n
 * @return none
 *
 * \par<b>Description: </b><br>
 * The function can be used for ramping up/down the system clock frequency.
 *
 * Example Usage:
 *
 * @code
 * #include <DAVE.h>
 *
 * int main(void)
 * {
 *   DAVE_STATUS_t init_status;
 *   uint32_t freq_khz = 1000U;  // 1MHz is the target frequency
 *   // Initialize CLOCK_XMC1 APP:
 *   // SystemCoreClockSetup() is called from SystemInit().
 *   init_status = DAVE_Init();
 *  if(DAVE_STATUS_SUCCESS == init_status)
 *  {
 *    CLOCK_XMC1_SetMCLKFrequency(freq_khz);  // system clock frequency is ramping down to 1 MHz
 *    // More code here
 *    while(1) {
 *
 *    }
 *  }
 *  return (1);
 * }
 * @endcode<BR>
 */
void CLOCK_XMC1_SetMCLKFrequency(uint32_t freq_khz);

#if (CLOCK_XMC1_OSCHP_ENABLED)
/**
 * @brief This is a non-weak function, which retrieves high precision external oscillator frequency.<br>
 * @return uint32_t Range: 4 to 20 in OSC_HP External Crystal Mode, 4 to 48 in OSC_HP External Direct Input Mode.
 *
 * \par<b>Description:</b><br>
 * This function to retrieves the external high precision oscillator frequency value, derived from either "External
 * Crystal Mode" or "External Direct Input Mode".<BR>
 * \par<b>Note:</b>\n
 * 1). This function is used by xmc1_scu LLD for internal operations. Therefore the user do not required to call
 * this API explicitly.\n
 * 2). This function is available for internal operations when device supports OSC_HP feature and OSC_HP option
 * is enabled in CLOCK_XMC1 APP GUI. This function is available for XMC14 device. \n
 */
uint32_t OSCHP_GetFrequency(void);
#endif

#if (CLOCK_XMC1_DCO1_CALIBRATION_ENABLED)
/**
 * @brief API to check whether DCO1 is synchronized to the XTAL frequency
 * @param  none
 * @return bool <br>
 *            true              : if DCO1 is synchronized to the XTAL frequency\n
 *            false             : if DCO1 is not synchronized to the XTAL frequency\n
 *
 * \par<b>Description: </b><br>
 * The function can be used to check whether DCO1 is synchronized to the XTAL frequency.<br>
 *
 * \par<b>Note:</b>\n
 * 1). This function is available to user when device supports DCO1 calibration feature and DCO1 calibration option
 * is enabled in CLOCK_XMC1 APP GUI. This function is available for XMC14 device. \n
 *
 * Example Usage:
 *
 * @code
 * #include <DAVE.h>
 *
 * int main(void)
 * {
 *   DAVE_STATUS_t init_status;
 *   #if(CLOCK_XMC1_DCO1_CALIBRATION_ENABLED)
 *   bool is_synchronized = false;
 *   #endif
 *   // Initialize CLOCK_XMC1 APP:
 *   // SystemCoreClockSetup() is called from SystemInit().
 *   init_status = DAVE_Init();
 *  if(DAVE_STATUS_SUCCESS == init_status)
 *  {
 *    // User code here
 *  #if(CLOCK_XMC1_DCO1_CALIBRATION_ENABLED)
 *    is_synchronized = CLOCK_XMC1_IsDCO1ExtRefCalibrationReady();  // check whether DCO1 is synchronized
 *                                                                  // to the XTAL frequency or not
 *    if(is_synchronized == true)
 *    {
 *     // User code here
 *     // Do baud rate configuration related to communication protocol
 *     // start PWM in compare mode
 *     // start RTC in the RTC domain
 *
 *    }
 *  #endif
 *    // More code here
 *    while(1) {
 *
 *    }
 *  }
 *  return (1);
 * }
 * @endcode<BR>
 */
bool CLOCK_XMC1_IsDCO1ExtRefCalibrationReady(void);
#endif

/**
 * @}
 */
#ifdef __cplusplus
}
#endif   

#include"clock_xmc1_extern.h"

#endif /* End of _CLOCK_XMC1_H_ */
